;*************************************************************************/
;                        MMU Functions                                   */
;*************************************************************************/

;*****************************************************************************/
; FUNCTION     : cfg_MMU                                                     */
; PURPOSE      : This function modifies the MMU TLB (translation lookaside   */
;                 buffer) table by writing to the appropriate MAS registers. */
; INPUT NOTES  : Requires SPRs defined and a data table for the TLB entries  */
;                mmu_tlb0 through mmu_tlb11, mmu_tlb15 from                  */
;                mpc5500_usrdefs.inc.                                        */
; RETURN NOTES : None                                                        */
; WARNING      : Registers used: R3,R5. Commands "msync" and "isync" are not */
;                required around the tlbwe since we are at configuration and */
;                 other background operations cannot be active.              */
;*****************************************************************************/
.global cfg_MMU

.section .text  


cfg_MMU:

  lis    r3, 0x1001       ; Select TLB entry #, define R/W replacment control 
  mtMAS0 r3               ; Load MAS0 with 0x1001 0000 for TLB entry #1 
  
                          ; Define description context and configuration control: 
                          ; VALID=1, IPROT=0, TID=0, TS=0, TSIZE=1 (4KB size) 
  lis    r3, 0x8000       ; Load MAS 1 with 0x8000 0100 
  ori    r3, r3, 0x0100
  mtMAS1 r3
  
                          ; Define EPN and page attributes: 
                          ; EPN = 0x4004 0000, WIMAGE = all 0
  lis    r3, 0x4004       ; Load MAS2 with 0x4004 0000 
  mtMAS2 r3
  
                          ; Define RPN and access control for data R/W 
                          ; RPN = 0x4004 0000, U0:3=0, UX/SX=0, UR/SR/UW/SW=1 
  lis    r3, 0x4004       ; Load MAS3 with 0x4004 000F 
  ori    r3, r3, 0x000F 
  mtMAS3 r3                 

  tlbwe


  ; Write MMU Assist Register 0 (MAS0); SPR 624 
    mtspr   624, r3
  
  ; Write MMU Assist Register 1 (MAS1); SPR 625 
    mtspr   625, r4
    
  ; Write MMU Assist Register 2 (MAS2); SPR 626 
    mtspr   626, r5
    
  ; Write MMU Assist Register 3 (MAS3); SPR 627 
    mtspr   627, r6
    
  ; Write the table entry 
    tlbwe

    blr
; End of cfg_MMU 

;*************************************************************************
